import { ACTION_SET_ACCESS_TOKEN_PARAMS } from 'actions/access-token';
import { ACTION_SET_ADBLOCK_DETECTED } from 'actions/ads';
import { accessToken, DEFAULT_ACCESS_TOKEN } from 'state/access-token';

QUnit.module('state | access-token', function() {
    QUnit.test('defaults to the default object', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.deepEqual(accessToken(undefined, action), DEFAULT_ACCESS_TOKEN);
    });

    QUnit.test('responds to the Set Access Token Params action', function(assert) {
        const params = {
            after: true,
        };
        const action = {
            type: ACTION_SET_ACCESS_TOKEN_PARAMS,
            params,
        };
        const beforeState = {
            params: {
                before: true,
            },
        };
        const afterState = {
            params,
        };

        assert.deepEqual(accessToken(beforeState, action), afterState);
    });

    QUnit.test('returns the current Access Token object otherwise', function(assert) {
        const action = {
            type: 'not a real action',
        };
        const beforeState = {
            params: {
                before: true,
            },
        };

        assert.equal(accessToken(beforeState, action), beforeState);
    });

    QUnit.test('defaults to true when setting the adblock status to unknown', function(assert) {
        const action = {
            type: ACTION_SET_ADBLOCK_DETECTED,
            detected: 'unknown',
        };

        const beforeState = {
            params: {
                adblock: false,
            },
        };

        const afterState = {
            params: {
                adblock: true,
            },
        };

        assert.deepEqual(accessToken(beforeState, action), afterState);
    });
});
