import { ACTION_SET_PLAYER_BACKEND_TYPE } from 'actions/backend-info';
import { backendInfo } from 'state/backend-info';

QUnit.module('state | backend-info', function() {
    QUnit.test('defaults to type of BackendBlank', function(assert) {
        const action = {
            type: 'not a real type',
        };
        const defaultBackend = backendInfo(undefined, action);
        assert.equal(defaultBackend.playerBackendType, 'blank');
    });

    QUnit.test('responds to the set setPlayerBackendType action and updates the backend type', function(assert) {
        const action = {
            type: ACTION_SET_PLAYER_BACKEND_TYPE,
            playerBackendType: 'a new type of backend, just for tests!',
        };
        const beforeState = {
            playerBackendType: 'blank',
        };
        const afterState = action.playerBackendType;
        assert.equal(backendInfo(beforeState, action).playerBackendType, afterState);
    });
});
