import { ACTION_SET_BACKEND } from 'actions/backend';
import { backend } from 'state/backend';

QUnit.module('state | backend', function() {
    QUnit.test('defaults to BackendBlank', function(assert) {
        const action = {
            type: 'not a real type',
        };
        const newBackend = backend(undefined, action);
        assert.equal(newBackend.getBackend(), 'blank');
    });

    QUnit.test('responds to the set backend action and updates the backend', function(assert) {
        const action = {
            type: ACTION_SET_BACKEND,
            backend: {},
        };
        const beforeState = {};
        const afterState = action.backend;
        assert.equal(backend(beforeState, action), afterState);
    });
});
