import { chromecast, UNAVAILABLE, AVAILABLE,
         CONNECTING, CONNECTED } from 'state/chromecast';
import { unitTest } from 'tests/utils/module';

const DEFAULT_CHROMECAST = {
    deviceName: '',
    castingState: UNAVAILABLE,
};

unitTest('state/chromecast', function() {
    QUnit.test('default properties are properly initialized', function(assert) {
        const action = { type: '@@init' };
        const result = chromecast(undefined, action);

        assert.deepEqual(result, DEFAULT_CHROMECAST);
    });

    QUnit.test('sets a device name given set device action', function(assert) {
        const action = {
            type: 'set device name',
            deviceName: 'spoopy-mcspooperson',
        };
        const beforeState = chromecast(undefined, { type: '@@init' });
        const afterState = chromecast(beforeState, action);

        assert.equal(afterState.deviceName, 'spoopy-mcspooperson');
    });

    function testCastingState(castingState) {
        QUnit.test('changes casting state if valid casting state', function(assert) {
            const action = {
                type: 'set casting state',
                castingState,
            };
            const beforeState = chromecast(undefined, { type: '@@init' });
            const afterState = chromecast(beforeState, action);

            assert.equal(afterState.castingState, castingState);
        });
    }

    testCastingState(UNAVAILABLE);
    testCastingState(AVAILABLE);
    testCastingState(CONNECTING);
    testCastingState(CONNECTED);

    QUnit.test('should not change if invalid casting state is passed', function(assert) {
        const castingState = QUnit.config.current.testId;
        const action = {
            type: 'set casting state',
            castingState,
        };
        const beforeState = chromecast(undefined, { type: '@@init' });
        const afterState = chromecast(beforeState, action);

        assert.equal(afterState.castingState, UNAVAILABLE);
    });
});
