import { clipRecommendations, DEFAULT_CLIP_RECOMMENDATIONS } from 'state/clip-recommendations';
import { ACTION_CLIP_RECOMMENDATIONS_LOADED } from 'actions/clip-recommendations';
import { clipStreamMetadata } from 'tests/fixtures/clip';

QUnit.module('state | clip-recommendations', function() {
    QUnit.test('returns the current clipRecommendations state otherwise', function(assert) {
        const action = {
            type: 'not a real action',
        };
        const actual = clipRecommendations({
            before: true,
        }, action);
        const expected = {
            before: true,
        };

        assert.deepEqual(actual, expected);
    });

    QUnit.test('updates data when receiving set clipRecommendations data action', function(assert) {
        const action = {
            type: ACTION_CLIP_RECOMMENDATIONS_LOADED,
            apiError: false,
            recommendationId: 'someClip',
            recommendationSets: {
                top: [clipStreamMetadata],
                similar: [clipStreamMetadata],
                channel: [clipStreamMetadata],
                curator: [clipStreamMetadata],
                game: [clipStreamMetadata],
            },
        };

        const newState = clipRecommendations(DEFAULT_CLIP_RECOMMENDATIONS, action);
        assert.deepEqual(newState, {
            byCategory: {
                top: [clipStreamMetadata.slug],
                similar: [clipStreamMetadata.slug],
                channel: [clipStreamMetadata.slug],
                curator: [clipStreamMetadata.slug],
                game: [clipStreamMetadata.slug],
            },
            allCategories: [
                'top',
                'similar',
                'channel',
                'curator',
                'game',
            ],
            hasFetched: {
                [action.recommendationId]: true,
            },
        });
    });
});
