import { clipsData, DEFAULT_CLIPS_DATA } from 'state/clips-data';
import { ACTION_CLIP_RECOMMENDATIONS_LOADED } from 'actions/clip-recommendations';
import { clipStreamMetadata } from 'tests/fixtures/clip';

QUnit.module('state | clips-data', function() {
    QUnit.test('returns the current clipsData state otherwise', function(assert) {
        const action = {
            type: 'not a real action',
        };
        const actual = clipsData({
            before: true,
        }, action);
        const expected = {
            before: true,
        };

        assert.deepEqual(actual, expected);
    });

    QUnit.test('updates data when receiving set clipsData data action', function(assert) {
        const action = {
            type: ACTION_CLIP_RECOMMENDATIONS_LOADED,
            apiError: false,
            recommendationId: 'someClip',
            recommendationSets: {
                top: [clipStreamMetadata],
                similar: [clipStreamMetadata],
                channel: [clipStreamMetadata],
                curator: [clipStreamMetadata],
                game: [clipStreamMetadata],
            },
        };

        const newState = clipsData(DEFAULT_CLIPS_DATA, action);
        assert.deepEqual(newState, {
            bySlug: {
                [clipStreamMetadata.slug]: clipStreamMetadata,
            },
            allSlugs: [
                clipStreamMetadata.slug,
            ],
        });
    });
});
