import { communities, DEFAULT_COMMUNITIES } from 'state/communities';
import { ACTION_INVALID_COMMUNITIES_DATA, ACTION_SET_COMMUNITIES_DATA } from 'actions/communities';

QUnit.module('state | communities', function() {
    QUnit.test('sets default state', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.deepEqual(communities(undefined, action), DEFAULT_COMMUNITIES);
    });

    QUnit.test('returns the current communities state otherwise', function(assert) {
        const action = {
            type: 'not a real action',
        };
        const actual = communities({
            before: true,
        }, action);
        const expected = {
            before: true,
        };

        assert.deepEqual(actual, expected);
    });

    QUnit.test('updates data when receiving set communities data action', function(assert) {
        const fakeCommunitiesData = {
            data: {
                _id: 'communityid',
                name: 'communityname',
            },
            ids: 'communityid',
        };

        const action = {
            type: ACTION_SET_COMMUNITIES_DATA,
            communities: fakeCommunitiesData,
        };

        const newState = communities(DEFAULT_COMMUNITIES, action);
        assert.deepEqual(newState, fakeCommunitiesData);
    });

    QUnit.test('does not update data when receiving invalid community action', function(assert) {
        const fakeCommunitiesData = {
            data: {
                _id: 'communityid2',
                name: 'communityname2',
            },
            ids: 'communityid2',
        };

        const action = {
            type: ACTION_INVALID_COMMUNITIES_DATA,
            communities: fakeCommunitiesData,
        };

        const newState = communities(DEFAULT_COMMUNITIES, action);
        assert.deepEqual(newState, DEFAULT_COMMUNITIES);
    });
});
