import Comscore from '../../../../vendor/streamsense.min.js';
import { comscore } from 'state/comscore';
import { unitTest } from 'tests/utils/module';

unitTest('state/comscore', function() {
    QUnit.test('initializes a streaming tag by default', function(assert) {
        const action = { type: '@@init' };
        const result = comscore(undefined, action);

        assert.ok(result.hasOwnProperty('streamingTag'));
        assert.ok(result.streamingTag instanceof Comscore.StreamingTag);
    });

    QUnit.test('returns a new tag given set stream action', function(assert) {
        const action = {
            type: 'set stream',
            stream: {},
        };
        const beforeState = comscore(undefined, { type: '@@init' });
        const afterState = comscore(beforeState, action);

        assert.notEqual(afterState.streamingTag, beforeState.streamingTag);
        assert.ok(afterState.streamingTag instanceof Comscore.StreamingTag);
    });

    QUnit.test('returns a new tag given reset tag action', function(assert) {
        const action = {
            type: 'reset tag',
        };
        const beforeState = comscore(undefined, { type: '@@init' });
        const afterState = comscore(beforeState, action);

        assert.notEqual(afterState.streamingTag, beforeState.streamingTag);
        assert.ok(afterState.streamingTag instanceof Comscore.StreamingTag);
    });

    QUnit.test('returns the current state otherwise', function(assert) {
        const action = {
            type: 'not a real action',
            streamingTag: {},
        };
        const beforeState = comscore(undefined, { type: '@@init' });

        assert.equal(comscore(beforeState, action), beforeState);
    });
});
