import { ACTION_ERROR, ACTION_CLEAR_ERROR } from 'actions/error';
import { error } from 'state/error';
import Errors from 'errors';

QUnit.module('state | error', function() {
    QUnit.test('defaults to -1 error code and false hasError', function(assert) {
        const beforeState = undefined;
        const action = {
            type: '@@init',
        };

        assert.deepEqual(error(beforeState, action), {
            hasError: false,
            code: -1,
        });
    });

    QUnit.test('responds to the Set error action', function(assert) {
        const beforeState = {
            hasError: false,
            code: -1,
        };
        const action = {
            type: ACTION_ERROR,
            code: Errors.CODES.ABORTED,
        };

        assert.deepEqual(error(beforeState, action), {
            hasError: true,
            code: action.code,
        });
    });

    QUnit.test('responds to the Clear error action', function(assert) {
        const beforeState = {
            hasError: true,
            code: Errors.CODES.ABORTED,
        };
        const action  = {
            type: ACTION_CLEAR_ERROR,
        };

        assert.deepEqual(error(beforeState, action), {
            hasError: false,
            code: -1,
        });
    });

    QUnit.test('returns the current error otherwise', function(assert) {
        const beforeState = {
            hasError: true,
            code: Errors.CODES.ABORTED,
        };
        const action = {
            type: 'not a real action',
            code: Errors.CODES.DECODE,
        };

        assert.deepEqual(error(beforeState, action), beforeState);
    });
});
