import isFunction from 'lodash/isFunction';
import { ACTION_SET_EXPERIMENTS } from 'actions/experiments';
import { experiments } from 'state/experiments';

QUnit.module('state | experiments', function() {
    QUnit.test('defaults to a null implementation', function(assert) {
        const someRandomUUID = 'ef1d1e8e-7e10-4563-9d9d-6b8bdf0c25ff';
        const action = {
            type: '@@init',
        };
        const beforeState = undefined;
        const afterState = experiments(beforeState, action);

        assert.ok(isFunction(afterState.get));
        return afterState.get(someRandomUUID).then(
            function(val) {
                assert.ok(false, `Expected to reject promise; got ${val}`);
            },
            function(err) {
                assert.ok(err instanceof Error);
            }
        );
    });

    QUnit.test('responds to the Set Experiments action', function(assert) {
        const action = {
            type: ACTION_SET_EXPERIMENTS,
            experiments: {},
        };
        const beforeState = {};
        const afterState = action.experiments;

        assert.equal(experiments(beforeState, action), afterState);
    });

    QUnit.test('returns the current experiment client otherwise', function(assert) {
        const action = {
            type: 'not a real action',
            irrelevant: {},
        };
        const beforeState = {};
        const afterState = beforeState;

        assert.equal(experiments(beforeState, action), afterState);
    });
});
