import * as FollowActions from 'actions/follow';
import { ACTION_SET_STREAM } from 'actions/stream';
import { follow } from 'state/follow';

QUnit.module('state | follow', function() {
    QUnit.test('defaults to a default channel-relationship object', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.deepEqual(follow(undefined, action), {
            fetched: false,
            following: false,
            notificationsEnabled: false,
            showFollowNotification: false,
        }, 'defaults fetched to false');
    });

    QUnit.test('should respond to ACTION_SHOW_FOLLOW_NOTIFICATION', function(assert) {
        const action = {
            type: FollowActions.ACTION_SHOW_FOLLOW_NOTIFICATION,
            show: true,
        };

        const afterState = follow(undefined, action);

        assert.equal(afterState.showFollowNotification, true);
    });

    QUnit.test('should respond to ACTION_FOLLOW_INFO_FETCHED', function(assert) {
        const followInfo = {
            following: true,
            notificationsEnabled: false,
        };

        const action = {
            type: FollowActions.ACTION_FOLLOW_INFO_FETCHED,
            followInfo,
        };

        const afterState = follow(undefined, action);

        assert.deepEqual(afterState, {
            fetched: true,
            following: true,
            notificationsEnabled: false,
            showFollowNotification: false,
        });

        assert.equal(afterState.fetched, true, 'sets fetched state to true');
    });

    QUnit.test('should set `fetched` and `showFollowNotification` to false on ACTION_SET_STREAM', function(assert) {
        const beforeState = {
            fetched: true,
            following: false,
            notificationsEnabled: false,
            showFollowNotification: true,
        };

        const action = {
            type: ACTION_SET_STREAM,
        };

        const afterState = follow(beforeState, action);

        assert.equal(afterState.fetched, false, 'resets fetched to false');
        assert.equal(afterState.showFollowNotification, false, 'resets showFollowNotification to false');
    });

    QUnit.test('should update an existing fetch state', function(assert) {
        const beforeState = {
            fetched: true,
            following: false,
            notificationsEnabled: false,
            showFollowNotification: true,
        };

        const action = {
            type: FollowActions.ACTION_FOLLOW_INFO_FETCHED,
            followInfo: {
                following: true,
                notificationsEnabled: true,
            },
        };

        assert.deepEqual(follow(beforeState, action), {
            fetched: true,
            following: true,
            notificationsEnabled: true,
            showFollowNotification: true,
        });
    });
});
