import { init } from 'state/index';

QUnit.module('state | index', function(hooks) {
    hooks.beforeEach(function() {
        this.store = init();
    });

    QUnit.test('has an `accessToken` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('accessToken'));
    });

    QUnit.test('has an `ads` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('ads'));
    });

    QUnit.test('has an `adsManager` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('adsManager'));
    });

    QUnit.test('has an `analytics` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('analytics'));
    });

    QUnit.test('has an `analyticsTracker` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('analyticsTracker'));
    });

    QUnit.test('has a `backend` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('backend'));
    });

    QUnit.test('has a `notifications` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('notifications'));
    });

    QUnit.test('has a `captions` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('captions'));
    });

    QUnit.test('has a `chromecast` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('chromecast'));
    });

    QUnit.test('has a `clips` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('clips'));
    });

    QUnit.test('has a `comscore` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('comscore'));
    });

    QUnit.test('has an `env` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('env'));
    });

    QUnit.test('has an `error` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('error'));
    });

    QUnit.test('has an `experiments` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('experiments'));
    });

    QUnit.test('has a `lang` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('lang'));
    });

    QUnit.test('has a `manifestInfo` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('manifestInfo'));
    });

    QUnit.test('has an `online` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('online'));
    });

    QUnit.test('has a `playback` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('playback'));
    });

    QUnit.test('has a `quality` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('quality'));
    });

    QUnit.test('has a `recommendations` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('recommendations'));
    });

    QUnit.test('has a `resumeWatch` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('resumeWatch'));
    });

    QUnit.test('has a `stats` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('stats'));
    });

    QUnit.test('has a `stream` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('stream'));
    });

    QUnit.test('has a `streamMetadata` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('streamMetadata'));
    });

    QUnit.test('has an `usher` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('usher'));
    });

    QUnit.test('has a `viewercount` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('viewercount'));
    });

    QUnit.test('has a `screen` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('screen'));
    });

    QUnit.test('has a `subscriptions` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('subscriptions'));
    });

    QUnit.test('has a `window` property', function(assert) {
        assert.ok(this.store.getState().hasOwnProperty('window'));
    });

    QUnit.test('should accept function actions that call `dispatch`', function(assert) {
        let ok = false;
        this.store.subscribe(() => ok = true);
        assert.notOk(ok);
        this.store.dispatch(dispatch => {
            dispatch({
                type: 'not important',
            });
        });
        assert.ok(ok);
    });
});
