import { DEFAULT_LANGUAGE } from 'lang/i18n';
import { ACTION_SET_LANGUAGE } from 'actions/lang';
import { lang as langReducer } from 'state/lang';

QUnit.module('state | lang', function() {
    QUnit.test('initializes to the default language', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.equal(langReducer(undefined, action), DEFAULT_LANGUAGE);
    });

    QUnit.test('responds to the Set Language action', function(assert) {
        const action = {
            type: ACTION_SET_LANGUAGE,
            lang: {},
        };
        const beforeState = {};

        assert.equal(langReducer(beforeState, action), action.lang);
    });

    QUnit.test('returns the current language otherwise', function(assert) {
        const action = {
            type: 'not a real action',
            lang: {},
        };
        const beforeState = {};

        assert.equal(langReducer(beforeState, action), beforeState);
    });
});
