import { ACTION_SET_MANIFEST_INFO } from 'actions/manifest-info';
import { ACTION_SET_STREAM } from 'actions/stream';
import { manifestInfo, DEFAULT_MANIFEST_INFO } from 'state/manifest-info';
import assign from 'lodash/assign';

QUnit.module('state | manifest-info', function() {
    QUnit.test('defaults to expected default object', function(assert) {
        assert.deepEqual(manifestInfo(undefined, { type: 'not a real type' }), DEFAULT_MANIFEST_INFO);
    });

    QUnit.test('responds to the set stream action', function(assert) {
        const action = {
            type: ACTION_SET_STREAM,
            info: {},
        };
        const beforeState = assign({}, DEFAULT_MANIFEST_INFO, {
            abs: true,
            bandwidth: 'something',
            cluster: 'something',
        });
        const afterState = DEFAULT_MANIFEST_INFO;

        assert.deepEqual(manifestInfo(beforeState, action), afterState);
    });

    QUnit.test('responds to the set manifest info action', function(assert) {
        const action = {
            type: ACTION_SET_MANIFEST_INFO,
            info: { abs: false },
        };
        const beforeState = DEFAULT_MANIFEST_INFO;
        const afterState = assign({}, DEFAULT_MANIFEST_INFO, action.info);

        assert.deepEqual(manifestInfo(beforeState, action), afterState);
    });

    QUnit.test('stores a number for stream_time rather than a string', function(assert) {
        const action = {
            type: ACTION_SET_MANIFEST_INFO,
            info: {
                abs: false,
                // eslint-disable-next-line camelcase
                stream_time: '123.4',
            },
        };
        const beforeState = DEFAULT_MANIFEST_INFO;
        // eslint-disable-next-line camelcase
        const afterState = assign({}, DEFAULT_MANIFEST_INFO, action.info, { stream_time: 123.4 });

        assert.deepEqual(manifestInfo(beforeState, action), afterState);
    });

    QUnit.test('returns the current manifest info', function(assert) {
        const action = {
            type: 'not a real action',
            info: {},
        };
        const beforeState = { abs: false };
        assert.equal(manifestInfo(beforeState, action), beforeState);
    });
});
