import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import * as NotificationsActions from 'actions/notifications';
import * as NotificationsState from 'state/notifications';
import concat from 'lodash/concat';
import slice from 'lodash/slice';

/* eslint-disable react/no-multi-comp */
function FirstPopUp() {
    return (
        <h1> first </h1>
    );
}

function SecondPopUp() {
    return (
        <h1> second </h1>
    );
}

function ThirdPopup() {
    return (
        <h1> third </h1>
    );
}

function AddedPopup() {
    return (
        <h1> added </h1>
    );
}

const EMPTY_NOTIFICATIONS = Object.freeze([]);
const DEFAULT_NOTIFICATIONS = Object.freeze([FirstPopUp, SecondPopUp, ThirdPopup]);
const TEST_ADD_NOTIFICATION = Object.freeze([AddedPopup]);
const TEST_REMOVE_NOTIFICATION = Object.freeze([FirstPopUp]);

reactTest('state | notifications', function() {
    QUnit.test('should default to default notifications array if none is set', function(assert) {
        const action = {
            type: '@@init',
        };
        const result = NotificationsState.notifications(undefined, action);
        assert.deepEqual(result, EMPTY_NOTIFICATIONS);
    });

    QUnit.test('responds to ACTION_ADD_NOTIFICATION', function(assert) {
        const action = {
            type: NotificationsActions.ACTION_ADD_NOTIFICATION,
            notification: TEST_ADD_NOTIFICATION,
        };

        const result = NotificationsState.notifications(DEFAULT_NOTIFICATIONS, action);
        assert.deepEqual(result, concat(action.notification, DEFAULT_NOTIFICATIONS));
    });

    QUnit.test('responds to ACTION_REMOVE_NOTIFICATION', function(assert) {
        const action = {
            type: NotificationsActions.ACTION_REMOVE_NOTIFICATION,
            notification: TEST_REMOVE_NOTIFICATION,
        };

        const result = NotificationsState.notifications(DEFAULT_NOTIFICATIONS, action);
        assert.deepEqual(result, slice(DEFAULT_NOTIFICATIONS, 1));
    });

    QUnit.test('should be able to add notification to empty array', function(assert) {
        const action = {
            type: NotificationsActions.ACTION_ADD_NOTIFICATION,
            notification: TEST_ADD_NOTIFICATION,
        };

        const result = NotificationsState.notifications(EMPTY_NOTIFICATIONS, action);
        assert.deepEqual(result, concat(action.notification, EMPTY_NOTIFICATIONS));
    });
});
