import { ACTION_SET_STREAMMETADATA } from 'actions/stream-metadata';
import { setOnline } from 'actions/online';
import { onlineStatus, ONLINE_STATUS, OFFLINE_STATUS, UNKNOWN_STATUS } from 'state/online-status';
import { ACTION_SET_STREAM } from 'actions/stream';

QUnit.module('state | online-status', function() {
    QUnit.test('defaults to UNKNOWN_STATUS', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.equal(onlineStatus(undefined, action), UNKNOWN_STATUS);
    });

    QUnit.test('responds to the setOnline true action', function(assert) {
        const action = setOnline(true);

        assert.equal(onlineStatus(UNKNOWN_STATUS, action), ONLINE_STATUS);
        assert.equal(onlineStatus(OFFLINE_STATUS, action), ONLINE_STATUS);
    });

    QUnit.test('responds to the setOnline false action', function(assert) {
        const action = setOnline(false);

        assert.equal(onlineStatus(UNKNOWN_STATUS, action), OFFLINE_STATUS);
        assert.equal(onlineStatus(ONLINE_STATUS, action), OFFLINE_STATUS);
    });

    QUnit.test('responds to the setStream action', function(assert) {
        const action = {
            type: ACTION_SET_STREAM,
        };

        assert.equal(onlineStatus(OFFLINE_STATUS, action), UNKNOWN_STATUS);
        assert.equal(onlineStatus(ONLINE_STATUS, action), UNKNOWN_STATUS);
        assert.equal(onlineStatus(UNKNOWN_STATUS, action), UNKNOWN_STATUS);
    });

    QUnit.test('updates as online when live stream metadata is successfully fetched', function(assert) {
        const action = {
            type: ACTION_SET_STREAMMETADATA,
            streamMetadata: {
                type: 'live',
            },
        };

        assert.equal(onlineStatus(OFFLINE_STATUS, action), ONLINE_STATUS);
        assert.equal(onlineStatus(UNKNOWN_STATUS, action), ONLINE_STATUS);
    });

    QUnit.test('updates with current state when non-live stream metadata is successfully fetched', function(assert) {
        const action = {
            type: ACTION_SET_STREAMMETADATA,
            streamMetadata: {
                type: 'archive',
            },
        };

        assert.equal(onlineStatus(ONLINE_STATUS, action), ONLINE_STATUS);
        assert.equal(onlineStatus(OFFLINE_STATUS, action), OFFLINE_STATUS);
        assert.equal(onlineStatus(UNKNOWN_STATUS, action), UNKNOWN_STATUS);
    });
});
