import { ACTION_SET_STREAMMETADATA } from 'actions/stream-metadata';
import { setOnline } from 'actions/online';
import { online } from 'state/online';

QUnit.module('state | online', function() {
    QUnit.test('defaults to offline', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.equal(online(undefined, action), false);
    });

    QUnit.test('responds to the setOnline true action', function(assert) {
        const action = setOnline(true);
        const beforeState = false;

        assert.equal(online(beforeState, action), true);
    });

    QUnit.test('updates as online when live stream metadata is successfully fetched', function(assert) {
        const action = {
            type: ACTION_SET_STREAMMETADATA,
            streamMetadata: {
                type: 'live',
            },
        };
        const beforeState = false;

        assert.equal(online(beforeState, action), true);
    });

    QUnit.test('updates with default state when non-live stream metadata is successfully fetched', function(assert) {
        const action = {
            type: ACTION_SET_STREAMMETADATA,
            streamMetadata: {
                type: 'archive',
            },
        };
        const beforeState = false;
        assert.equal(online(beforeState, action), beforeState);
    });

    QUnit.test('returns offline state otherwise', function(assert) {
        const action = {
            type: 'not a real action',
            online: true,
        };
        const beforeState = false;

        assert.equal(online(beforeState, action), beforeState);
    });
});
