import { ACTION_UPDATE_PLAYER_DIMENSIONS } from 'actions/player-dimensions';
import * as PlayerDimensionsState from 'state/player-dimensions';
import assign from 'lodash/assign';

const DEFAULT_PLAYER_DIMENSIONS = Object.freeze({
    left: 0,
    top: 0,
    width: 0,
    height: 0,
});

const TEST_PLAYER_DIMENSIONS_FULL_UPDATE = Object.freeze({
    left: 200,
    top: 200,
    width: 200,
    height: 200,
});

const TEST_PLAYER_DIMENSIONS_UPDATE_LEFT = Object.freeze({
    left: 100,
    top: 200,
    width: 200,
    height: 200,
});

const TEST_PLAYER_DIMENSIONS_UPDATE_TOP = Object.freeze({
    left: 200,
    top: 100,
    width: 200,
    height: 200,
});

const TEST_PLAYER_DIMENSIONS_UPDATE_WIDTH = Object.freeze({
    left: 200,
    top: 200,
    width: 100,
    height: 200,
});

const TEST_PLAYER_DIMENSIONS_UPDATE_HEIGHT = Object.freeze({
    left: 200,
    top: 200,
    width: 200,
    height: 100,
});

QUnit.module('state | playerDimensions', function() {
    QUnit.test('should default to default playerDimensions if none is set', function(assert) {
        const action = {
            type: '@@init',
        };
        const result = PlayerDimensionsState.playerDimensions(undefined, action);

        assert.deepEqual(result, DEFAULT_PLAYER_DIMENSIONS);
    });

    QUnit.test('responds to ACTION_UPDATE_PLAYER_DIMENSIONS', function(assert) {
        const action = {
            type: ACTION_UPDATE_PLAYER_DIMENSIONS,
            playerDimensions: TEST_PLAYER_DIMENSIONS_FULL_UPDATE,
        };

        const result = PlayerDimensionsState.playerDimensions(DEFAULT_PLAYER_DIMENSIONS, action);

        assert.deepEqual(result, assign({}, DEFAULT_PLAYER_DIMENSIONS, action.playerDimensions));
    });

    function testPlayerDimensionsUpdates(playerDimensions, message) {
        QUnit.test(message, function(assert) {
            const action = {
                type: ACTION_UPDATE_PLAYER_DIMENSIONS,
                playerDimensions,
            };

            const result = PlayerDimensionsState.playerDimensions(TEST_PLAYER_DIMENSIONS_FULL_UPDATE, action);
            assert.deepEqual(result, assign({}, TEST_PLAYER_DIMENSIONS_FULL_UPDATE, action.playerDimensions));
        });
    }

    testPlayerDimensionsUpdates(TEST_PLAYER_DIMENSIONS_UPDATE_LEFT, 'updates just left');
    testPlayerDimensionsUpdates(TEST_PLAYER_DIMENSIONS_UPDATE_TOP, 'updates just top');
    testPlayerDimensionsUpdates(TEST_PLAYER_DIMENSIONS_UPDATE_WIDTH, 'updates just width');
    testPlayerDimensionsUpdates(TEST_PLAYER_DIMENSIONS_UPDATE_HEIGHT, 'updates just height');
});
