import { ACTION_SET_PROVIDED_OPTIONS } from 'actions/player-options';
import { playerOptions, DEFAULT_PROVIDED_OPTIONS } from 'state/player-options';

QUnit.module('state | player-options', function() {
    QUnit.test('defaults to default options', function(assert) {
        const beforeState = undefined;
        const action = {
            type: '@@init',
        };

        const expectedState = {
            branding: true,
            showInfo: true,
            showtheatre: false,
            collection: '',
            channel: '',
            channelId: '',
            video: '',
            // eslint-disable-next-line camelcase
            tt_content: '',
            // eslint-disable-next-line camelcase
            tt_medium: '',
        };

        assert.deepEqual(playerOptions(beforeState, action), expectedState);
    });

    QUnit.test('responds to the `set provided options` action', function(assert) {
        const testId = QUnit.config.current.testId;
        const options = {
            branding: false,
            showInfo: true,
            showtheatre: false,
            collection: `collection_${testId}`,
            video: `video_${testId}`,
            channel: `channel_${testId}`,
            channelId: `channelId_${testId}`,
            /* eslint-disable camelcase */
            tt_content: 'content',
            tt_medium: 'medium',
            force_preroll: false,
            force_midroll: false,
            force_preroll_id: 0,
            force_midroll_id: 0,
            /* eslint-enable camelcase */
        };

        const action = {
            type: ACTION_SET_PROVIDED_OPTIONS,
            playerOptions: options,
        };

        const beforeState = DEFAULT_PROVIDED_OPTIONS;
        const expectedState = options;

        assert.deepEqual(playerOptions(beforeState, action), expectedState);
    });

    QUnit.test('returns the current options otherwise', function(assert) {
        const testId = QUnit.config.current.testId;
        const beforeState = {
            branding: false,
            showInfo: true,
            showtheatre: false,
            collection: `collection_${testId}`,
            video: `video_${testId}`,
            channel: `channel_${testId}`,
            channelId: `channelId_${testId}`,
            /* eslint-disable camelcase */
            tt_content: 'content',
            tt_medium: 'medium',
            force_preroll: false,
            force_midroll: false,
            force_preroll_id: 0,
            force_midroll_id: 0,
            /* eslint-enable camelcase */
        };

        const action = {
            type: 'not a real action',
            options: {},
        };

        assert.deepEqual(playerOptions(beforeState, action), beforeState);
    });
});
