import * as QualityActions from 'actions/quality';
import { quality } from 'state/quality';
import { unitTest } from 'tests/utils/module';

unitTest('state/quality', function() {
    QUnit.test('responds to the Select Quality action', function(assert) {
        const action = {
            type: QualityActions.ACTION_SELECT_QUALITY,
            quality: 'low',
        };
        const beforeState = quality(undefined, { type: '@@init' });

        assert.equal(quality(beforeState, action).selected, action.quality);
    });

    QUnit.test('responds to the set abs availability action', function(assert) {
        const action = {
            type: QualityActions.ACTION_SET_ABS_AVAILABILITY,
            absAvailable: true,
        };
        const beforeState = quality(undefined, { type: '@@init' });

        assert.equal(quality(beforeState, action).absAvailable, action.absAvailable);
    });

    QUnit.test('responds to the Set Current Quality action', function(assert) {
        const action = {
            type: QualityActions.ACTION_SET_CURRENT_QUALITY,
            quality: 'low',
        };
        const beforeState = quality(undefined, { type: '@@init' });

        assert.equal(quality(beforeState, action).current, action.quality);
    });

    QUnit.test('responds to the Set Qualities action', function(assert) {
        const action = {
            type: QualityActions.ACTION_SET_QUALITIES,
            qualities: [
                {
                    name: 'Source',
                    group: 'chunked',
                    bandwidth: 2000000,
                    resolution: '1920x1080',
                },
                {
                    name: 'High',
                    group: 'high',
                    bandwidth: 1700000,
                    resolution: '1280x720',
                },
            ],
        };
        const beforeState = quality(undefined, { type: '@@init' });

        assert.equal(quality(beforeState, action).available, action.qualities);
    });

    QUnit.test('returns the current quality settings otherwise', function(assert) {
        const action = {
            type: 'not a real action',
            quality: QUnit.config.current.testId,
        };
        const beforeState = quality(undefined, { type: '@@init' });

        assert.equal(quality(beforeState, action), beforeState);
    });
});
