import { recommendations } from 'state/recommendations';
import { V3_VIDEOS_RESPONSE } from 'tests/fixtures/recommendations';
import { ACTION_SET_RECOMMENDED_VODS, ACTION_CLEAR_RECOMMENDED_VODS, ACTION_SET_NUM_VODS_VISIBLE,
         ACTION_SET_FETCHING_STATUS, UNFETCHED, FETCHING,
         FETCHED, POST_VOD_RECOMMENDATIONS_TYPE } from 'actions/recommendations';
import { ACTION_SET_STREAM } from 'actions/stream';
import assign from 'lodash/assign';

const DEFAULT_STATE = {
    type: '',
    videos: [],
    numVideosVisible: 0,
    status: UNFETCHED,
};

QUnit.module('state | recommendations', function() {
    QUnit.test('should return default recommendations if none is set', function(assert) {
        const action = {
            type: '@@init',
        };

        const expectedState = DEFAULT_STATE;

        assert.deepEqual(recommendations(undefined, action), expectedState);
    });

    QUnit.test('responds to set recommended vods action', function(assert) {
        const action = {
            type: ACTION_SET_RECOMMENDED_VODS,
            recommendationsType: POST_VOD_RECOMMENDATIONS_TYPE,
            videos: V3_VIDEOS_RESPONSE.videos,
        };

        const beforeState = DEFAULT_STATE;
        const expectedState = {
            type: action.recommendationsType,
            numVideosVisible: beforeState.numVideosVisible,
            videos: action.videos,
            status: FETCHED,
        };

        assert.deepEqual(recommendations(beforeState, action), expectedState);
    });

    QUnit.test('should return current recommendation list', function(assert) {
        const action = {
            type: 'blahblahblah',
        };

        const beforeState = {
            type: POST_VOD_RECOMMENDATIONS_TYPE,
            videos: V3_VIDEOS_RESPONSE.videos,
            numVideosVisible: 0,
            status: FETCHED,
        };

        assert.deepEqual(recommendations(beforeState, action), beforeState);
    });

    QUnit.test('should set numVideosVisible correctly', function(assert) {
        const numVids = parseInt(QUnit.config.current.testId, 36);
        const action = {
            type: ACTION_SET_NUM_VODS_VISIBLE,
            numVids,
        };

        const beforeState = DEFAULT_STATE;
        const expectedState = assign({}, DEFAULT_STATE, {
            numVideosVisible: action.numVids,
        });

        assert.deepEqual(recommendations(beforeState, action), expectedState);
    });

    QUnit.test('should set fetching status correctly', function(assert) {
        const action = {
            type: ACTION_SET_FETCHING_STATUS,
            status: FETCHING,
        };

        const beforeState = DEFAULT_STATE;
        const expectedState = assign({}, DEFAULT_STATE, {
            status: action.status,
        });

        assert.deepEqual(recommendations(beforeState, action), expectedState);
    });

    QUnit.test('should set recommendations to default on ACTION_SET_STREAM', function(assert) {
        const action = {
            type: ACTION_SET_STREAM,
        };

        const beforeState = {
            type: POST_VOD_RECOMMENDATIONS_TYPE,
            videos: V3_VIDEOS_RESPONSE.videos,
            numVideosVisible: 0,
            status: FETCHED,
        };
        const expectedState = DEFAULT_STATE;

        assert.deepEqual(recommendations(beforeState, action), expectedState);
    });

    QUnit.test('should set recommendations to default on ACTION_CLEAR_RECOMMENDED_VODS', function(assert) {
        const action = {
            type: ACTION_CLEAR_RECOMMENDED_VODS,
        };

        const beforeState = {
            type: POST_VOD_RECOMMENDATIONS_TYPE,
            videos: V3_VIDEOS_RESPONSE.videos,
            numVideosVisible: 0,
            status: FETCHED,
        };
        const expectedState = DEFAULT_STATE;

        assert.deepEqual(recommendations(beforeState, action), expectedState);
    });
});
