import * as SettingsActions from 'actions/settings';
import { settings } from 'state/settings';

QUnit.module('state | settings', function() {
    QUnit.test('defaults to the proper state', function(assert) {
        const action = {
            type: '@@init',
        };

        const expectedState = {
            persistenceEnabled: true,
        };

        assert.propEqual(settings(undefined, action), expectedState);
    });

    QUnit.test('responds to the SET_PERSISTENCE action', function(assert) {
        const enableAction = {
            type: SettingsActions.ACTION_SET_PERSISTENCE,
            value: true,
        };

        const disableAction = {
            type: SettingsActions.ACTION_SET_PERSISTENCE,
            value: false,
        };

        const beforeState = {
            persistenceEnabled: true,
        };

        let state = settings(beforeState, disableAction);

        assert.notOk(state.persistenceEnabled, 'sets persistenceEnabled false when value is false');

        state = settings(state, enableAction);

        assert.ok(state.persistenceEnabled, 'sets persistenceEnabled true value is true');
    });
});
