import { ACTION_UPDATE_STATS, ACTION_DISPLAY_STATS } from 'actions/stats';
import { DEFAULT_STATS, stats } from 'state/stats';

QUnit.module('state | stats', function() {
    QUnit.test('defaults to default stats', function(assert) {
        const action = {
            type: '@@init',
        };

        const afterState = DEFAULT_STATS;

        assert.equal(stats(undefined, action), afterState);
    });

    QUnit.test('responds to the update stats action', function(assert) {
        const mockVideoStats = {
            playbackRate: 6854.3,
            fps: 55,
            bufferSize: 5.27,
            skippedFrames: 28,
            memoryUsage: '164.2MB',
            hlsLatencyEncoder: 4.63,
            hlsLatencyBroadcaster: 8.63,
            videoResolution: '1920x1080',
            displayResolution: '756x1319',
        };

        const action = {
            type: ACTION_UPDATE_STATS,
            videoStats: mockVideoStats,
        };

        const beforeState = { videoStats: DEFAULT_STATS.videoStats };
        const afterState = { videoStats: mockVideoStats };

        assert.deepEqual(stats(beforeState, action), afterState);
    });

    QUnit.test('responds to the display stats action', function(assert) {
        const action = {
            type: ACTION_DISPLAY_STATS,
            displayed: true,
        };

        const beforeState = { displayed: false };
        const afterState = { displayed: true };

        assert.deepEqual(stats(beforeState, action), afterState);
    });

    QUnit.test('returns the current stats otherwise', function(assert) {
        const action = {
            type: 'not a real action',
            stats: this.mockStats,
        };

        const beforeState = DEFAULT_STATS;
        const afterState = DEFAULT_STATS;

        assert.equal(stats(beforeState, action), afterState);
    });
});
