import { ACTION_SET_STREAM } from 'actions/stream';
import { nullContentStream } from 'stream/null';
import { stream } from 'state/stream';

QUnit.module('state | stream', function() {
    QUnit.test('defaults to the null content stream', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.equal(stream(undefined, action), nullContentStream);
    });

    QUnit.test('responds to the Set Stream action', function(assert) {
        const action = {
            type: ACTION_SET_STREAM,
            stream: {},
        };
        const beforeState = nullContentStream;

        assert.equal(stream(beforeState, action), action.stream);
    });

    QUnit.test('returns the current content stream otherwise', function(assert) {
        const action = {
            type: 'not a real action',
        };
        const beforeState = {};

        assert.equal(stream(beforeState, action), beforeState);
    });
});
