import { subscriptions } from 'state/subscriptions';
import {
    ACTION_CHANNEL_SUBSCRIPTIONS_FETCHED,
    ACTION_SUBSCRIPTION_PRODUCTS_FETCHED,
} from 'actions/subscriptions';
import { ACTION_SET_STREAM } from 'actions/stream';

QUnit.module('state | subscriptions', function() {
    QUnit.test('has defaults', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.deepEqual(subscriptions(undefined, action), {
            isSubscribed: false,
            isSubscribable: false,
            didFetch: false,
        }, 'defaults isSubscribed, isSubscribable, and didFetch to false');
    });

    QUnit.test('should respond to ACTION_CHANNEL_SUBSCRIPTIONS_FETCHED', function(assert) {
        const action = {
            type: ACTION_CHANNEL_SUBSCRIPTIONS_FETCHED,
            subscriptions: {
                isSubscribed: true,
                isSubscribable: true,
            },
        };

        const afterState = subscriptions(undefined, action);

        assert.deepEqual(afterState, {
            didFetch: true,
            isSubscribed: true,
            isSubscribable: true,
        }, 'sets didFetch, isSubscribed, and isSubscribable to true');
    });

    QUnit.test('should respond to ACTION_SUBSCRIPTION_PRODUCTS_FETCHED', function(assert) {
        const action = {
            type: ACTION_SUBSCRIPTION_PRODUCTS_FETCHED,
            subscriptions: {
                isSubscribable: true,
            },
        };

        const afterState = subscriptions(undefined, action);

        assert.deepEqual(afterState, {
            didFetch: false,
            isSubscribed: false,
            isSubscribable: true,
        }, 'sets isSubscribable to true');
    });

    QUnit.test('resets to default values on stream set state', function(assert) {
        const initialState = {
            isSubscribed: true,
            isSubscribable: true,
            didFetch: true,
        };

        const action = {
            type: ACTION_SET_STREAM,
        };

        assert.deepEqual(subscriptions(initialState, action), {
            isSubscribed: false,
            isSubscribable: false,
            didFetch: false,
        }, 'reverts to default values');
    });
});
