import { unitTest } from 'tests/utils/module';
import { ACTION_SET_TRACKING_PROPERTIES } from 'actions/tracking';
import { tracking } from 'state/tracking';

unitTest('state | tracking', function() {
    QUnit.test('defaults to empty object', function(assert) {
        const beforeState = undefined;
        const action = {
            type: 'not a real action',
        };

        assert.deepEqual(tracking(beforeState, action), {});
    });

    QUnit.test('responds to the set properties action if using a whitelisted property', function(assert) {
        const beforeState = {};
        const properties = {
            /* eslint-disable camelcase */
            app_session_id: 'appsessionid',
            benchmark_session_id: 'benchmarksessionid',
            chat_visibility_status: 'visible',
            client_app: 'someapp',
            content: 'foo',
            host_channel: 'extalix',
            medium: 'baz',
            page_session_id: 'deadbeef',
            player: 'someplayer',
            referrer: 'referrer',
            referrer_url: 'referrerurl',
            tab_session_id: 'c45c4de5',
            feed_impression_id: 'fjdlk9iu0-fdjklu8-fdhjkasl8',
            /* eslint-enable camelcase */
        };
        const action = {
            type: ACTION_SET_TRACKING_PROPERTIES,
            properties,
        };

        assert.deepEqual(tracking(beforeState, action), properties);
    });

    QUnit.test('does not respond to the set properties action if not using a whitelisted property', function(assert) {
        const beforeState = {};
        const properties = {
            notWhitelisted: 'extalix',
        };

        const action = {
            type: ACTION_SET_TRACKING_PROPERTIES,
            properties,
        };

        assert.deepEqual(tracking(beforeState, action), beforeState);
    });
});
