import * as UIActions from 'actions/ui';
import { ui } from 'state/ui';
import { EXTENSION_MENU_MAIN, EXTENSION_MENU_MANAGE_ACCESS } from 'util/extensions';

QUnit.module('state | ui', function() {
    QUnit.test('defaults to the proper state', function(assert) {
        const action = {
            type: '@@init',
        };

        const expectedState = {
            isMini: false,
            showSettings: UIActions.MENU_STATE_NONE,
            showExtensionsSubmenu: EXTENSION_MENU_MAIN,
            showUI: false,
            onUIElement: false,
            showVolumeSlider: true,
        };

        assert.propEqual(ui(undefined, action), expectedState);
    });

    QUnit.test('responds to the setMiniPlayerMode action', function(assert) {
        const action = {
            type: UIActions.ACTION_SET_MINIPLAYER_MODE,
            value: true,
        };

        const beforeState = {
            isMini: false,
        };

        const afterState = ui(beforeState, action);

        assert.equal(afterState.isMini, true);
    });

    QUnit.test('responds to the showSettings action', function(assert) {
        const action = {
            type: UIActions.ACTION_SHOW_SETTINGS_MENU,
            value: UIActions.MENU_STATE_SETTINGS,
        };

        const beforeState = {
            showSettings: UIActions.MENU_STATE_NONE,
        };

        const afterState = ui(beforeState, action);

        assert.equal(afterState.showSettings, UIActions.MENU_STATE_SETTINGS);
    });

    QUnit.test('responds to the showSettings action when showExtensionsSubmenu is set', function(assert) {
        const action = {
            type: UIActions.ACTION_SHOW_SETTINGS_MENU,
            value: UIActions.MENU_STATE_SETTINGS,
            extensionsSubmenu: EXTENSION_MENU_MANAGE_ACCESS,
        };

        const beforeState = {
            showSettings: UIActions.MENU_STATE_NONE,
        };

        const afterState = ui(beforeState, action);

        assert.equal(afterState.showSettings, UIActions.MENU_STATE_SETTINGS);
        assert.equal(afterState.showExtensionsSubmenu, EXTENSION_MENU_MANAGE_ACCESS);
    });

    QUnit.test('responds to the set ui display action', function(assert) {
        const action = {
            type: UIActions.ACTION_SET_UI_DISPLAY,
            showUI: true,
        };

        const beforeState = {
            showUI: false,
        };

        const afterState = ui(beforeState, action);

        assert.equal(afterState.showUI, true, 'showUI should be updated');
    });

    QUnit.test('responds to the hovering on ui element action', function(assert) {
        const action = {
            type: UIActions.ACTION_HOVERING_ON_UI_ELEMENT,
        };

        const beforeState = {
            onUIElement: true,
        };

        const afterState = ui(beforeState, action);

        assert.equal(afterState.onUIElement, true, 'onUIElement should be true');
    });

    QUnit.test('responds to the hovering off ui element action', function(assert) {
        const action = {
            type: UIActions.ACTION_HOVERING_OFF_UI_ELEMENT,
        };

        const beforeState = {
            onUIElement: true,
        };

        const afterState = ui(beforeState, action);

        assert.equal(afterState.onUIElement, false, 'onUIElement should be false');
    });

    QUnit.test('responds to the show volume slider action', function(assert) {
        const action = {
            type: UIActions.ACTION_SHOW_VOLUME_SLIDER,
            value: false,
        };

        const beforeState = {
            showVolumeSlider: true,
        };

        const afterState = ui(beforeState, action);

        assert.equal(afterState.showVolumeSlider, false, 'showVolumeSlider should be false');
    });
});
