import { ACTION_USER_LOGGED_IN, ACTION_USER_NOT_LOGGED_IN } from 'actions/user';
import { user as userReducer, UNKNOWN, NOT_LOGGED_IN,
         LOGGED_IN } from 'state/user';
import assign from 'lodash/assign';

const DEFAULT_USER_DATA = {
    loggedInStatus: UNKNOWN,
    id: 0,
    isStaff: false,
    name: '',
};

QUnit.module('state | user', function() {
    QUnit.test('defaults to UNKNOWN logged in status and default user data', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.deepEqual(userReducer(undefined, action), DEFAULT_USER_DATA);
    });

    QUnit.test('responds to user logged in action', function(assert) {
        const action = {
            type: ACTION_USER_LOGGED_IN,
            userInfo: {
                id: 12346,
                isStaff: true,
                name: `user_${QUnit.config.current.testId}`,
            },
        };

        const expectedState = assign({}, DEFAULT_USER_DATA, action.userInfo, {
            loggedInStatus: LOGGED_IN,
        });

        assert.deepEqual(userReducer(DEFAULT_USER_DATA, action), expectedState);
    });

    QUnit.test('responds to user not logged in action', function(assert) {
        const action = {
            type: ACTION_USER_NOT_LOGGED_IN,
        };

        const expectedState = assign({}, DEFAULT_USER_DATA, {
            loggedInStatus: NOT_LOGGED_IN,
        });

        assert.deepEqual(userReducer(DEFAULT_USER_DATA, action), expectedState);
    });
});
