import * as UsherActions from 'actions/usher';
import { DEFAULT_USHER, usher } from 'state/usher';

QUnit.module('state | usher', function() {
    QUnit.test('defaults to expected object', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.deepEqual(usher(undefined, action), DEFAULT_USHER);
    });

    QUnit.test('responds to the Set Usher Params action', function(assert) {
        const action = {
            type: UsherActions.ACTION_SET_USHER_PARAMS,
            params: {
                after: true,
            },
        };
        const beforeState = {
            hostOverride: '',
            params: {
                before: true,
            },
        };
        const afterState = {
            hostOverride: '',
            params: action.params,
        };

        assert.deepEqual(usher(beforeState, action), afterState);
    });

    QUnit.test('responds to the Set Usher Host Override action', function(assert) {
        const action = {
            type: UsherActions.ACTION_SET_USHER_HOST_OVERRIDE,
            hostOverride: 'https://newusherhost.tv',
        };
        const beforeState = {
            hostOverride: '',
            params: {},
        };
        const afterState = {
            hostOverride: action.hostOverride,
            params: {},
        };

        assert.deepEqual(usher(beforeState, action), afterState);
    });

    QUnit.test('returns the current Usher state otherwise', function(assert) {
        const action = {
            type: 'not a real action',
        };
        const beforeState = {
            before: true,
        };

        assert.equal(usher(beforeState, action), beforeState);
    });
});
