import { ACTION_SET_STREAMMETADATA } from 'actions/stream-metadata';
import { ACTION_UPDATE_VIEWERCOUNT } from 'actions/viewercount';
import { viewercount } from 'state/viewercount';

QUnit.module('state | viewercount', function() {
    QUnit.test('defaults to 0 viewers', function(assert) {
        assert.equal(viewercount(undefined, { type: 'not a real type' }), 0);
    });

    QUnit.test('responds to the update viewercount action', function(assert) {
        const action = {
            type: ACTION_UPDATE_VIEWERCOUNT,
            count: 50,
        };
        const beforeState = 0;
        const afterState = action.count;

        assert.equal(viewercount(beforeState, action), afterState);
    });

    QUnit.test('updates with appropriate count when live stream metadata is successfully fetched', function(assert) {
        const action = {
            type: ACTION_SET_STREAMMETADATA,
            streamMetadata: {
                viewers: 123,
            },
        };
        const beforeState = 0;
        const afterState = action.streamMetadata.viewers;

        assert.equal(viewercount(beforeState, action), afterState);
    });

    QUnit.test('returns the current viewercount otherwise', function(assert) {
        const action = {
            type: 'not a real action',
            count: 35,
        };
        const beforeState = 5;
        assert.equal(viewercount(beforeState, action), beforeState);
    });
});
