import assign from 'lodash/assign';
import { ACTION_SET_WATCHPARTY_VOD } from 'actions/watch-party';
import { DEFAULT_WATCHPARTY, watchParty } from 'state/watch-party';

QUnit.module('state | watch-party', function() {
    QUnit.test('defaults to the default watch party', function(assert) {
        const action = {
            type: '@@init',
        };

        assert.equal(watchParty(undefined, action), DEFAULT_WATCHPARTY);
    });

    QUnit.test('responds to the Set Watch Party VOD action', function(assert) {
        const action = {
            type: ACTION_SET_WATCHPARTY_VOD,
            pubsubVodInfo: {
                watchPartyId: '2',
            },
        };
        const beforeState = DEFAULT_WATCHPARTY;

        assert.deepEqual(watchParty(beforeState, action), assign({}, beforeState, { watchPartyId: '2' }));
    });

    QUnit.test('returns the current watch party otherwise', function(assert) {
        const action = {
            type: 'not a real action',
        };
        const beforeState = {};

        assert.equal(watchParty(beforeState, action), beforeState);
    });
});
