import { ACTION_SET_WINDOW } from 'actions/window';
import { windowReducer } from 'state/window';

QUnit.module('state | window', function() {
    QUnit.test('defaults to the global `window`', function(assert) {
        const beforeState = undefined;
        const action = {
            type: '@@init',
        };

        assert.equal(windowReducer(beforeState, action), window);
    });

    QUnit.test('responds to the Set Window action', function(assert) {
        const beforeState = {};
        const action = {
            type: ACTION_SET_WINDOW,
            window: {},
        };

        assert.equal(windowReducer(beforeState, action), action.window);
    });

    QUnit.test('returns the current window otherwise', function(assert) {
        const beforeState = {};
        const action = {
            type: 'not a real action',
            window: {},
        };
        const afterState = beforeState;

        assert.equal(windowReducer(beforeState, action), afterState);
    });
});
