import { unitTest } from 'tests/utils/module';
import { CONTENT_MODE_CLIP, ClipContentStream } from 'stream/clip';

unitTest('stream | clip', function(hooks) {
    hooks.beforeEach(function() {
        this.slug = 'SomeSlug';
        this.stream = new ClipContentStream(this.slug);
    });

    QUnit.test('contentType should be clip', function(assert) {
        assert.equal(this.stream.contentType, CONTENT_MODE_CLIP);
    });

    QUnit.test('channel should return empty string', function(assert) {
        assert.equal(this.stream.channel, '');
    });

    QUnit.test('videoId should return empty string', function(assert) {
        assert.equal(this.stream.videoId, '');
    });

    QUnit.test('slug should return passed in slug', function(assert) {
        assert.equal(this.stream.slug, this.slug);
    });

    QUnit.test('accessToken is promise that resolves to empty object', function(assert) {
        return this.stream.accessToken.then(function(value) {
            assert.deepEqual(value, {});
        });
    });

    QUnit.test('streamUrl is a promise that resolves with empty string', function(assert) {
        return this.stream.streamUrl.then(streamUrl => {
            assert.equal(streamUrl, '');
        });
    });

    // eslint-disable-next-line max-len
    QUnit.test('castStreamUrl returns empty string', function(assert) {
        return this.stream.castStreamUrl.then(castStreamUrl => {
            assert.equal(castStreamUrl, '');
        });
    });
});
