import { CONTENT_MODE_NONE, nullContentStream } from 'stream/null';

QUnit.module('stream | null', function() {
    QUnit.test('contentType should be nothing', function(assert) {
        assert.equal(nullContentStream.contentType, CONTENT_MODE_NONE);
    });

    QUnit.test('channel should be empty', function(assert) {
        assert.equal(nullContentStream.channel, '');
    });

    QUnit.test('videoId should be empty', function(assert) {
        assert.equal(nullContentStream.videoId, '');
    });

    QUnit.test('slug should be empty', function(assert) {
        assert.equal(nullContentStream.slug, '');
    });

    QUnit.test('streamUrl should resolve to empty string', function(assert) {
        assert.expect(1);
        return nullContentStream.streamUrl.then(url => {
            assert.equal(url, '');
        });
    });
});
