import { unitTest } from 'tests/utils/module';
import { CONTENT_MODE_VIDEO_SOURCE, VideoSourceContentStream } from 'stream/video-source';

unitTest('stream | video-source', function(hooks) {
    hooks.beforeEach(function() {
        this.url = 'https://twitch.tv/some.mp4';
        this.stream = new VideoSourceContentStream(this.url);
    });

    QUnit.test('contentType should be video-source', function(assert) {
        assert.equal(this.stream.contentType, CONTENT_MODE_VIDEO_SOURCE);
    });

    QUnit.test('channel should return empty string', function(assert) {
        assert.equal(this.stream.channel, '');
    });

    QUnit.test('videoId should return empty string', function(assert) {
        assert.equal(this.stream.videoId, '');
    });

    QUnit.test('accessToken is promise that resolves to empty object', function(assert) {
        return this.stream.accessToken.then(function(value) {
            assert.deepEqual(value, {});
        });
    });

    QUnit.test('streamUrl is a promise that resolves with video source url', function(assert) {
        return this.stream.streamUrl.then(streamUrl => {
            assert.equal(streamUrl, this.url, 'streamUrl should equal passed in url');
        });
    });

    QUnit.test('castStreamUrl returns passed in video source url', function(assert) {
        return this.stream.castStreamUrl.then(castStreamUrl => {
            assert.equal(castStreamUrl, this.url, 'castStreamUrl should equal passed in url');
        });
    });
});
