import { oauthToken } from 'api';
import { SubscribeOverlayManager } from 'subscribe-overlay-manager';
import { init as initStore } from 'state';
import { unitTest } from 'tests/utils/module';
import { ACTION_SET_STREAM } from 'actions/stream';
import { VODTwitchContentStream } from 'stream/twitch-vod';
import { pushScreen, VOD_RESTRICTED_SCREEN } from 'actions/screen';
import { waitFor } from 'tests/utils/waitFor';
import sinon from 'sinon';

unitTest('subscribe-overlay manager', function(hooks) {
    hooks.beforeEach(function() {
        this.store = initStore();
        this.videoID = `v${Math.floor(Math.random() * 1e8)}`;
        this.broadcastID = `${parseInt(QUnit.config.current.testId, 36)}`;

        /* eslint-disable camelcase */
        const videoData = {
            broadcast_id: this.broadcastID,
            channel: {
                name: 'channelName',
                partner: false,
            },
            restrictions: ['chansub'],
        };

        this.viewer = {
            chansub: null,
            is_admin: false,
        };

        /* eslint-enable camelcase */

        oauthToken.cache.clear();

        this.api.setLoggedIn(false);
        this.api.expectVideoInfo(this.videoID, videoData);
        this.api.expectChannelInfo(videoData.channel.name, videoData.channel);
        this.api.expectChannelViewerInfo(videoData.channel.name, this.viewer);
    });

    QUnit.module('SubscribeOverlayManager', function(hooks) {
        hooks.beforeEach(function() {
            this.uiSubscribeOverlay = new SubscribeOverlayManager(this.store);
        });

        QUnit.test('dispatches VOD_RESTRICTED_SCREEN if the stream is a restricted VOD', function(assert) {
            sinon.spy(this.store, 'dispatch');

            this.store.dispatch({
                type: ACTION_SET_STREAM,
                stream: new VODTwitchContentStream(this.videoID),
            });

            return waitFor(() => this.store.dispatch.calledWith(pushScreen(VOD_RESTRICTED_SCREEN))).then(() => {
                assert.equal(
                    this.store.getState().screen[0],
                    VOD_RESTRICTED_SCREEN,
                    'Top screen should be VOD_RESTRICTED_SCREEN'
                );
            });
        });
    });
});
