import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { BackgroundBanner } from 'ui/components/background-banner';

const DEFAULT_ARGS = Object.freeze({
    imgUrl: '',
    bgType: '',
    onContentShowing() {},
});

function renderBackgroundBanner(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <BackgroundBanner {...args} />;
    return shallow(component);
}

reactTest('ui | components | background-banner', function() {
    QUnit.test('renders a div with the correct base class', function(assert) {
        const component = renderBackgroundBanner();
        assert.equal(component.type(), 'div', 'renders a div');
        assert.ok(component.hasClass('pl-background-banner'), 'has correct base class');
    });

    function testClasses(bgType, expectedModifier) {
        QUnit.test(`adds a class with a ${expectedModifier} modifier`, function(assert) {
            const component = renderBackgroundBanner({ bgType });
            assert.ok(component.hasClass(`pl-background-banner--${expectedModifier}`), 'has correct class');
        });
    }

    testClasses('offline-banner', 'offline');
    testClasses('video-preview', 'preview');

    QUnit.test('loads the background img url', function(assert) {
        const imgUrl = 'http://this.is.a.meme.gif';
        const component = renderBackgroundBanner({ imgUrl });
        const { style } = component.props();

        assert.deepEqual(style, {
            backgroundImage: `url(${imgUrl})`,
        }, 'loads correct background image');
    });
});
