import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { PausePlayButton } from 'ui/containers/buttons/pause-play-button';
import { VolumeSlider } from 'ui/containers/volume-slider';
import { BottomLeftControls, CONTAINER_CLASSES } from 'ui/components/bottom-controls/bottom-left-controls';

reactTest('ui | components | bottom-controls | bottom-left-controls', function() {
    QUnit.test('has expected classes', function(assert) {
        const component = shallow(<BottomLeftControls />);
        assert.ok(component.hasClass(CONTAINER_CLASSES));
    });

    QUnit.test('has pause play button and volume slider', function(assert) {
        const component = shallow(<BottomLeftControls />);
        assert.ok(component.contains(<PausePlayButton />), 'has pauseplay button');
        assert.ok(component.contains(<VolumeSlider />), 'has volume slider');
    });
});
