import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { NotificationPopUpsWrapper } from 'ui/containers/notifications-container';
import { Settings } from 'ui/containers/settings';
import { ExtensionSettings } from 'ui/containers/extension-settings';
import { ClosedCaptionButton } from 'ui/containers/buttons/closed-caption-button';
import { ClipsButton } from 'ui/containers/buttons/clips-button';
import { ChromecastButton } from 'ui/containers/buttons/chromecast-button';
import { TheatreModeButton } from 'ui/containers/buttons/theatre-mode-button';
import { FullScreenButton } from 'ui/containers/buttons/fullscreen-button';
import { WatchTwitchButton } from 'ui/containers/buttons/watch-twitch-button';
import { BottomRightControlsComponent, CONTAINER_CLASSES } from 'ui/components/bottom-controls/bottom-right-controls';
import { ShareButton } from 'ui/player-types/clips/buttons/share-button';
import assign from 'lodash/assign';

const DEFAULT_PROPS = Object.freeze({
    shouldShowShareButton: false,
});

function renderBottomRightControls(opts = {}) {
    const props = assign({}, DEFAULT_PROPS, opts);
    const component = <BottomRightControlsComponent {...props} />;
    return shallow(component);
}

reactTest('ui | components | bottom-controls | bottom-right-controls', function() {
    QUnit.test('has expected classes', function(assert) {
        const component = renderBottomRightControls();
        assert.ok(component.hasClass(CONTAINER_CLASSES));
    });

    QUnit.test('has expected subcomponents', function(assert) {
        const component = renderBottomRightControls();
        assert.ok(component.contains(<NotificationPopUpsWrapper />), 'has notifications wrapper');
        assert.ok(component.contains(<Settings />), 'has settings');
        assert.ok(component.contains(<ExtensionSettings />), 'has extension settings');
        assert.ok(component.contains(<ClosedCaptionButton />), 'has CC button');
        assert.ok(component.contains(<ClipsButton />), 'has clips button');
        assert.ok(component.contains(<ChromecastButton />), 'has chromecast button');
        assert.ok(component.contains(<TheatreModeButton />), 'has theatre mode button');
        assert.ok(component.contains(<FullScreenButton />), 'has fullscreen button');
        assert.ok(component.contains(<WatchTwitchButton />), 'has watch twitch button');
    });

    QUnit.test('has share component when shouldShowShareButton is true', function(assert) {
        const component = renderBottomRightControls({ shouldShowShareButton: true });
        assert.ok(component.contains(<ShareButton />), 'has share button');
    });

    QUnit.test('has no share component when shouldShowShareButton is false', function(assert) {
        const component = renderBottomRightControls({ shouldShowShareButton: false });
        assert.ok(!component.contains(<ShareButton />), 'has no share button');
    });
});
