import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { CaptionsButton } from 'ui/components/buttons/captions-button';
import * as buttonTestHelper from 'tests/utils/player-buttons-helpers';

reactTest('ui | components | buttons', function() {
    QUnit.module('captions button', function(hooks) {
        hooks.beforeEach(function() {
            this.renderFullscreenButton = buttonTestHelper.createRenderFn(CaptionsButton, {
                captionsEnabled: false,
                turnOn: () => {},
                turnOff: () => {},
            });
        });

        QUnit.module('when captionsEnabled', function() {
            runCaptionsSuite(true);
        });

        QUnit.module('when not captionsEnabled', function() {
            runCaptionsSuite(false);
        });

        // eslint-disable-next-line complexity
        function runCaptionsSuite(captionsEnabled) {
            const label = 'Captions';
            const iconId = captionsEnabled ? '#icon_cc_off' : '#icon_cc_on';
            const turnOn = sinon.spy();
            const turnOff = sinon.spy();
            const shouldFire = captionsEnabled ? turnOff : turnOn;
            const shouldNotFire = captionsEnabled ? turnOn : turnOff;

            QUnit.test(`label should be ${label}`, function(assert) {
                const component = this.renderFullscreenButton({ captionsEnabled });
                buttonTestHelper.testLabel(component, label, assert);
            });

            QUnit.test(`should fire ${captionsEnabled ? 'turnOn' : 'turnOff'} when clicked`, function(assert) {
                const component = this.renderFullscreenButton({
                    captionsEnabled,
                    turnOn,
                    turnOff,
                });

                buttonTestHelper.testClickHandler({
                    component,
                    shouldFire,
                    shouldNotFire,
                    assert,
                });
            });

            QUnit.test(`should have icon id ${iconId}`, function(assert) {
                const component = this.renderFullscreenButton({ captionsEnabled });
                buttonTestHelper.testIconId(component, iconId, assert);
            });
        }
    });
});
