import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ClipsButton } from 'ui/components/buttons/clips-button';
import { Icon } from 'ui/components/buttons/base-icon';

const DEFAULT_ARGS = Object.freeze({
    hasAltShortcut: false,
    onClip() {},
});

function renderButton(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClipsButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | buttons | clips-button', function() {
    QUnit.test('if hasAltShortcut, the label includes info about alt+x', function(assert) {
        const component = renderButton({
            hasAltShortcut: true,
        });

        assert.equal(component.find(Icon).props().label, 'Clip (Alt+X)');
    });

    QUnit.test('if there is no alt shortcut, label only says `Clips`', function(assert) {
        const component = renderButton({
            hasAltShortcut: false,
        });

        assert.equal(component.find(Icon).props().label, 'Clip');
    });
});
