import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ClosePopupButton } from 'ui/components/buttons/close-popup-button';
import sinon from 'sinon';

const DEFAULT_ARGS = Object.freeze({
    close() {},
});

function renderButton(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClosePopupButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | buttons | close-popup-button', function() {
    QUnit.test('can be closed', function(assert) {
        const close = sinon.spy();
        const component = renderButton({ close });

        assert.equal(close.callCount, 0, 'precond - close not called');

        component.find('[data-test-close-popup-button-close]').simulate('click');
        assert.equal(close.callCount, 1, 'close called');
    });
});
