import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { ClosedCaptionButton } from 'ui/components/buttons/closed-caption-button';
import * as buttonTestHelper from 'tests/utils/player-buttons-helpers';

reactTest('ui | components | buttons | closed-caption-button', function(hooks) {
    hooks.beforeEach(function() {
        this.renderButton = buttonTestHelper.createRenderFn(ClosedCaptionButton, {
            captionsEnabled: false,
            onDisableCaptions: () => {},
            onEnableCaptions: () => {},
        });
    });

    QUnit.module('when captions enabled', function() {
        runCCSuite('true');
    });

    QUnit.module('when captions disabled', function() {
        runCCSuite('false');
    });

    function runCCSuite(captionsEnabled) {
        const label = 'Captions';
        const iconId = captionsEnabled ? '#icon_cc_on' : '#icon_cc_off';
        const onDisableCaptions = sinon.spy();
        const onEnableCaptions = sinon.spy();
        const shouldFire = captionsEnabled ? onDisableCaptions : onEnableCaptions;
        const shouldNotFire = captionsEnabled ? onEnableCaptions : onDisableCaptions;

        QUnit.test('label should be Captions', function(assert) {
            const component = this.renderButton({ captionsEnabled });
            buttonTestHelper.testLabel(component, label, assert);
        });

        // eslint-disable-next-line max-len
        QUnit.test(`should fire ${captionsEnabled ? 'onDisableCaptions' : 'onEnableCaptions'} when clicked`, function(assert) {
            const component = this.renderButton({
                captionsEnabled,
                onDisableCaptions,
                onEnableCaptions,
            });

            buttonTestHelper.testClickHandler({
                component,
                shouldFire,
                shouldNotFire,
                assert,
            });
        });

        QUnit.test(`should have icon id ${iconId}`, function(assert) {
            const component = this.renderButton({ captionsEnabled });
            buttonTestHelper.testIconId(component, iconId, assert);
        });
    }
});
