import { reactTest } from 'tests/utils/react-test';
import sinon from 'sinon';
import { NotificationsButtonComponent } from 'ui/components/buttons/notifications-button';
import * as buttonTestHelper from 'tests/utils/player-buttons-helpers';

const DEFAULT_ARGS = Object.freeze({
    t: t => t,
    enable: () => {},
    disable: () => {},
    notificationsEnabled: false,
});

reactTest('ui | components | buttons', function() {
    QUnit.module('notifications button', function(hooks) {
        hooks.beforeEach(function() {
            this.renderNotificationsButton = buttonTestHelper.createRenderFn(
                NotificationsButtonComponent,
                DEFAULT_ARGS
            );
        });

        QUnit.test('When notifications are enabled', function(assert) {
            const enable = sinon.spy();
            const disable = sinon.spy();
            const component = this.renderNotificationsButton({
                notificationsEnabled: true,
                enable,
                disable,
            });

            assert.equal(
                component.childAt(0).text(),
                'Notifications',
                'Shows notifications are enabled.'
            );

            component.simulate('click');

            assert.equal(disable.callCount, 1, 'disable is called');
            assert.equal(enable.callCount, 0, 'enable is not called');
        });

        QUnit.test('When notifications are disabled', function(assert) {
            const enable = sinon.spy();
            const disable = sinon.spy();
            const component = this.renderNotificationsButton({
                notificationsEnabled: false,
                enable,
                disable,
            });

            assert.equal(
                component.childAt(0).text(),
                'Turn On Notifications',
                'Asks user to turn on notifications.'
            );

            component.simulate('click');

            assert.equal(enable.callCount, 1, 'enable is called');
            assert.equal(disable.callCount, 0, 'disable is not called');
        });
    });
});
