import sinon from 'sinon';
import { reactTest } from 'tests/utils/react-test';
import { PausePlayButton } from 'ui/components/buttons/pause-play-button';
import * as buttonTestHelper from 'tests/utils/player-buttons-helpers';
import { ReplaySVG } from 'ui/player-types/clips/common/svg/replay';

reactTest('ui | components | buttons', function() {
    QUnit.module('pause play button', function(hooks) {
        hooks.beforeEach(function() {
            this.renderPausePlayButton = buttonTestHelper.createRenderFn(PausePlayButton, {
                paused: false,
                showReplay: false,
                onPlay: () => {},
                onPause: () => {},
            });
        });

        QUnit.module('when showReplay true', function() {
            QUnit.module('when paused', function() {
                runPausePlaySuite(true, true);
            });

            QUnit.module('when not paused', function() {
                runPausePlaySuite(false, true);
            });
        });

        QUnit.module('when showReplay false', function() {
            QUnit.module('when paused', function() {
                runPausePlaySuite(true, false);
            });

            QUnit.module('when not paused', function() {
                runPausePlaySuite(false, false);
            });
        });

        // eslint-disable-next-line complexity
        function runPausePlaySuite(paused, showReplay) {
            const label = paused ? 'Play' : 'Pause';
            const iconId = paused ? '#icon_play' : '#icon_pause';
            const onPlay = sinon.spy();
            const onPause = sinon.spy();
            const shouldFire = paused ? onPlay : onPause;
            const shouldNotFire = paused ? onPause : onPlay;

            QUnit.test(`label should be ${label}`, function(assert) {
                const component = this.renderPausePlayButton({
                    paused,
                    showReplay,
                });

                if (showReplay) {
                    assert.equal(component.find(ReplaySVG).length, 1, 'find replay svg');
                } else {
                    assert.equal(component.find(ReplaySVG).length, 0, 'no replay svg');
                    buttonTestHelper.testLabel(component, label, assert);
                }
            });

            QUnit.test(`should fire ${paused ? 'onPlay' : 'onPause'} when clicked`, function(assert) {
                const component = this.renderPausePlayButton({
                    paused,
                    onPlay,
                    onPause,
                });

                buttonTestHelper.testClickHandler({
                    component,
                    shouldFire,
                    shouldNotFire,
                    assert,
                });
            });

            QUnit.test(`should have icon id ${iconId}`, function(assert) {
                const component = this.renderPausePlayButton({ paused });
                buttonTestHelper.testIconId(component, iconId, assert);
            });
        }
    });
});
