import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { Button } from 'ui/components/buttons/base-button';
import { RecCloseButton } from 'ui/components/buttons/rec-close-button';

const DEFAULT_PROPS = Object.freeze({
    onClick: () => {},
});

function shallowRenderButton(overrides = {}) {
    const args = assign({}, DEFAULT_PROPS, overrides);
    const component = <RecCloseButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | buttons | rec-close-button', function() {
    QUnit.test('sets proper svg class', function(assert) {
        const buttonComponent = shallowRenderButton();
        const SVGComponent = buttonComponent.childAt(0).childAt(0);
        assert.ok(SVGComponent.hasClass('pl-close-button__svg'));
    });

    QUnit.test('sets proper icon link', function(assert) {
        const buttonComponent = shallowRenderButton();
        const SVGComponent = buttonComponent.childAt(0).childAt(0);
        assert.equal(SVGComponent.childAt(0).prop('xlinkHref'), '#pl-icon_close');
    });

    QUnit.test('sets button onClick prop correctly', function(assert) {
        const buttonComponent = shallowRenderButton();
        assert.equal(buttonComponent.type(), Button);
        assert.equal(buttonComponent.prop('onClick'), DEFAULT_PROPS.onClick);
    });

    QUnit.test('appends button className with additional className prop', function(assert) {
        const additionalClassName = 'another-classname';
        const buttonComponent = shallowRenderButton({
            className: additionalClassName,
        });

        assert.ok(buttonComponent.hasClass('pl-close-button'));
        assert.ok(buttonComponent.hasClass(additionalClassName));
    });
});
