import { reactTest } from 'tests/utils/react-test';
import sinon from 'sinon';
import { TheatreModeButton } from 'ui/components/buttons/theatre-mode-button';
import * as buttonTestHelper from 'tests/utils/player-buttons-helpers';

reactTest('ui | components | buttons | theatre-mode-button', function(hooks) {
    hooks.beforeEach(function() {
        this.renderTheatreModeButton = buttonTestHelper.createRenderFn(TheatreModeButton, {
            theatreModeEnabled: false,
            turnOn: () => {},
            turnOff: () => {},
        });
    });

    QUnit.module('when theatreModeEnabled', function() {
        runTheatreModeSuite(true);
    });

    QUnit.module('when not theatreModeEnabled', function() {
        runTheatreModeSuite(false);
    });

    // eslint-disable-next-line complexity
    function runTheatreModeSuite(theatreModeEnabled) {
        const label = theatreModeEnabled ?  'Exit Theatre Mode' : 'Theatre Mode';
        const iconId = theatreModeEnabled ? '#icon_theatre_deactivate' : '#icon_theatre';
        const turnOn = sinon.spy();
        const turnOff = sinon.spy();
        const shouldFire = theatreModeEnabled ? turnOff : turnOn;
        const shouldNotFire = theatreModeEnabled ? turnOn : turnOff;

        QUnit.test(`label should be ${label}`, function(assert) {
            const component = this.renderTheatreModeButton({ theatreModeEnabled });
            buttonTestHelper.testLabel(component, label, assert);
        });

        QUnit.test(`should fire ${theatreModeEnabled ? 'turnOff' : 'turnOn'} when clicked`, function(assert) {
            const component = this.renderTheatreModeButton({
                theatreModeEnabled,
                turnOn,
                turnOff,
            });

            buttonTestHelper.testClickHandler({
                component,
                shouldFire,
                shouldNotFire,
                assert,
            });
        });

        QUnit.test(`should have icon id ${iconId}`, function(assert) {
            const component = this.renderTheatreModeButton({ theatreModeEnabled });
            buttonTestHelper.testIconId(component, iconId, assert);
        });
    }
});
