import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { Button } from 'ui/components/buttons/base-button';
import { Icon } from 'ui/components/buttons/base-icon';
import { WatchTwitchButton } from 'ui/components/buttons/watch-twitch-button';

const DEFAULT_PROPS = Object.freeze({
    onClick: () => {},
});

function shallowRenderButton(overrides = {}) {
    const args = assign({}, DEFAULT_PROPS, overrides);
    const component = <WatchTwitchButton {...args} />;
    return shallow(component);
}

reactTest('ui | components | buttons | watch-twitch-button', function() {
    QUnit.test('sets correct icon', function(assert) {
        const buttonComponent = shallowRenderButton();
        const iconComponent = buttonComponent.childAt(0);
        assert.equal(iconComponent.type(), Icon);
        assert.equal(iconComponent.prop('iconId'), '#icon_twitch');
        assert.equal(iconComponent.prop('labelClass'), 'player-tip--aright');
    });

    QUnit.test('sets buttonLabel property', function(assert) {
        const buttonLabel = 'Come check it out on Twitch, fool!';

        const buttonComponent = shallowRenderButton({
            buttonLabel,
        });
        const iconComponent = buttonComponent.childAt(0);
        assert.equal(iconComponent.type(), Icon);
        assert.equal(iconComponent.prop('label'), buttonLabel);
    });

    QUnit.test('sets button onClick prop correctly', function(assert) {
        const buttonComponent = shallowRenderButton();
        assert.equal(buttonComponent.type(), Button);
        assert.equal(buttonComponent.prop('onClick'), DEFAULT_PROPS.onClick);
    });
});
