import React from 'react';
import assign from 'lodash/assign';
import { shallow } from 'enzyme';
import { ClosedCaptions as ClosedCaptionsComponent } from 'ui/components/closed-captions/closed-captions';
import { reactTest } from 'tests/utils/react-test';

const BASE_STYLES = Object.freeze({
    fontSize: 20,
    font: 'prop-sans-serif',
    fontOpacity: 'solid',
    alignment: 'left',
    edge: 'none',
    verticalPosition: 'bottom',
    backgroundColorName: 'black',
    backgroundOpacity: 'solid',
    windowColorName: 'transparent',
    windowOpacity: 'solid',
    fontUnderline: 'none',
    fontBold: 'none',
    fontItalic: 'none',
});

const DEFAULT_ARGS = Object.freeze({
    captionsText: ['Hello', 'World'],
    captionsStyle: BASE_STYLES,
});

function renderClosedCaptionsComponent(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClosedCaptionsComponent {...args} />;
    return shallow(component);
}

reactTest('ui | components | closed-captions | closed-captions', function() {
    QUnit.test('displays captions text', function(assert) {
        const component = renderClosedCaptionsComponent();
        const rows = component.find('.player-captions-row');

        assert.equal(rows.length, 2, 'two rows generated');

        assert.equal(
            rows.at(0).text(),
            'Hello',
            'renders first row'
        );

        assert.equal(
            rows.at(1).text(),
            'World',
            'renders first row'
        );
    });

    function testComponentStyles(className, expectedStyles) {
        QUnit.test(`${className} has correct styles`, function(assert) {
            const component = renderClosedCaptionsComponent();
            const container = component.find(className);
            const { style } = container.props();
            assert.deepEqual(style, expectedStyles, 'correct styles are generated');
        });
    }

    testComponentStyles('.player-captions-container', {
        top: 'auto',
        bottom: '10%',
        textAlign: 'left',
        fontSize: 20,
    });

    testComponentStyles('.player-captions-window', {
        backgroundColor: 'transparent',
    });

    testComponentStyles('.player-captions', {
        alignment: 'left',
        animation: 'none',
        backgroundColor: 'rgba(0,0,0,1)',
        backgroundColorName: 'black',
        backgroundOpacity: 'solid',
        color: 'rgba(255,255,255,1)',
        edge: 'none',
        font: 'prop-sans-serif',
        fontBold: 'none',
        fontFamily: 'Verdana, Arial, Helvetica, "PT Sans Caption", sans-serif',
        fontItalic: 'none',
        fontOpacity: 'solid',
        fontStyle: 'normal',
        fontUnderline: 'none',
        fontVariant: 'normal',
        fontWeight: 'normal',
        textDecoration: 'none',
        textShadow: 'none',
        verticalPosition: 'bottom',
        windowColorName: 'transparent',
        windowOpacity: 'solid',
    });
});
