import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { EffectsPanel } from 'ui/components/closed-captions/effects-panel';
import { TextStylePalette } from 'ui/components/closed-captions/text-style-palette';
import { TextEffectsPalette } from 'ui/components/closed-captions/text-effects-palette';

const DEFAULT_ARGS = Object.freeze({
    boldText: false,
    italicText: false,
    underlineText: false,
    currentTextEffect: '',
    selectTextEffect() {},
    selectTextStyle() {},
});

reactTest('ui | components | closed-captions | effects-panel', function() {
    QUnit.test('renders a div with correct styles', function(assert) {
        const component = shallow(<EffectsPanel {...DEFAULT_ARGS} />);
        assert.equal(component.type(), 'div', 'renders a div');
        assert.ok(component.hasClass('cc-panel-menu-frame'), 'has correct class');
    });

    QUnit.test('renders a TextStylePalette with correct props', function(assert) {
        const component = shallow(<EffectsPanel {...DEFAULT_ARGS} />);
        const textStylePalette = component.childAt(0);

        assert.equal(
            textStylePalette.type(),
            TextStylePalette,
            'renders a TextStylePalette'
        );

        assert.deepEqual(textStylePalette.props(), {
            boldText: false,
            underlineText: false,
            italicText: false,
            selectTextStyle: DEFAULT_ARGS.selectTextStyle,
        }, 'has correct props');
    });

    QUnit.test('renders a TextEffectsPalette with correct props', function(assert) {
        const component = shallow(<EffectsPanel {...DEFAULT_ARGS} />);
        const textEffectsPalette = component.childAt(1);

        assert.equal(
            textEffectsPalette.type(),
            TextEffectsPalette,
            'renders a TextEffectsPalette'
        );

        assert.deepEqual(textEffectsPalette.props(), {
            currentTextEffect: DEFAULT_ARGS.currentTextEffect,
            selectTextEffect: DEFAULT_ARGS.selectTextEffect,
        }, 'has correct props');
    });
});
